// console.log("global.js local");

/**
 * @file
 * Global utilities.
 *
 */
(function ($, Drupal) {
  "use strict";

  Drupal.behaviors.bootstrap_barrio_subtheme = {
    attach: function (context, settings) {
      // console.log("drupal js work");
    },
  };
})(jQuery, Drupal);

// Button Responsive
const buttonResponsive = document.querySelector(".js-button-responsive");
const menuResponsive = document.querySelector(".js-main-menu-target");
if (buttonResponsive) {
  buttonResponsive.addEventListener("click", function () {
    menuResponsive.classList.toggle("show");
  });
}

// js extract time
const jsTime = document.querySelectorAll(".js-time-origin");
jsTime.forEach(function (item) {
  let origin = item.querySelector(".datetime");
  let yearTarget = item.querySelector(".js-time-year");
  let year = origin.innerHTML.substr(11, 4);
  yearTarget.innerText = year;
});

// icons in products
const jsIcons = document.querySelector(".js-icons-products");
if (jsIcons) {
  const icons = jsIcons.querySelectorAll(".field--name-field-titulo-del-icono");

  icons.forEach((item) => {
    let name = item.innerText;
    item.innerText = "";
    item.classList.add(name);
  });

  const file = document.querySelector(".js-file-products .file a");
  if (file) {
    file.classList.add("btn", "btn-primary", "btn-block");
  }

}

// breadcrump
const pageTitle = document.querySelector(".js-page-title");
if (pageTitle) {
  const current = document.querySelector(".js-breadcrumb-current");
  current.innerText = pageTitle.innerText;
}

// testimony
const testimony = document.querySelector(".js-testimony");
if (testimony) {
  const starOut = document.querySelector(".js-testimony--stars-out").innerText;
  const starIn = document.querySelector(".js-testimony--stars-in");
  const items = document.querySelectorAll(".js-testimony--row");
  const inner = document.querySelector(".js-testimony--inner");

  starIn.classList.add("stars-" + starOut);

  for (let i = 0; i < items.length; i++) {
    i === 0 ? items[i].classList.add("active") : null;
    inner.appendChild(items[i]);
  }
}

// ligthbox
const productsList = document.querySelectorAll(".c-products__thumbnails");
if (productsList[0]) {
  const lightbox = document.querySelector(".js-lightbox-target");
  const close = document.querySelector(".js-lightbox-close");
  const items = productsList[0].querySelectorAll(".field__item");

  console.log(lightbox);

  for (let i = 0; i < items.length; i++) {
    items[i].addEventListener("click", () => {
      lightbox.classList.toggle("js-open");
    });
  }

  close.addEventListener("click", () => {
    lightbox.classList.toggle("js-open");
  });
}

const bannerNodeParams = {
  idSelector: document.querySelector("#bannerNode"),
  bannerImages: document.querySelectorAll("#bannerNode .banner-images img"),
  bannerContainer: document.querySelector("#bannerNode .banner-container"),
  bannerVideo: document.querySelector("#bannerNode .banner-video"),
};

const bannerGalleryParams = {
  idSelector: document.querySelector("#bannerContentType"),
  bannerImages: document.querySelectorAll(
    "#bannerContentType .banner-images img"
  ),
  bannerContainer: document.querySelector(
    "#bannerContentType .banner-container"
  ),
  bannerVideo: document.querySelector("#bannerContentType .banner-video"),
};

const productsGalleryParams = {
  idSelector: document.querySelector("#productsGallery"),
  bannerImages: document.querySelectorAll(".c-products__thumbnails img"),
  bannerContainer: document.querySelector("#productsGallery .banner-container"),
  bannerVideo: "",
};

console.log("1");
createBanner(bannerNodeParams);
console.log("2");
createBanner(bannerGalleryParams);
console.log("3");
createBanner(productsGalleryParams);
console.log("4");

function videoConstructor(url) {
  function idVideo(urlString) {
    if (!urlString.startsWith("https://www.youtube.com/")) {
      console.log(" la url del video no es correcta ", urlString);
      return;
    }

    const search = new URL(urlString).search;
    const idVideo = new URLSearchParams(search).get("v");
    return idVideo;
  }

  let videoItem = `
      <div class="carousel-item  c-custom-carousel__video">
        <iframe
          width="853"
          height="480"
          src="https://www.youtube.com/embed/${idVideo(url)}"
          title="YouTube video player"0
          frameborder="0"
          allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
          allowfullscreen
        ></iframe>;
      </div>`;
  return videoItem;
}

function createBanner({
  idSelector,
  bannerImages,
  bannerContainer,
  bannerVideo,
}) {
  if (idSelector === null) {
    console.log("id no existe");
    return;
  }

  let indicators = "";
  let sliders;
  let sliderVideo;
  let name = idSelector.id + "__name";
  let numberSliders = bannerImages.length;

  if (bannerVideo.innerText) {
    numberSliders = numberSliders + 1;
    sliderVideo = videoConstructor(bannerVideo.innerText);
  }

  if (numberSliders === 0) {
    return;
  }

  bannerImages.forEach((element, index) => {
    let src = element.getAttribute("src");
    let active = index == 0 ? "active" : "";
    let slider = `
      <div class="carousel-item ${active}">
      <img
      alt="First slide"
      class="d-block w-100"
      src="${src}"
      />
      </div>`;

    sliders += slider;
  });

  for (let index = 0; index < numberSliders; index++) {
    let active = index == 0 ? "active" : "";
    let indicator = `
      <li data-bs-target="#${name}" data-bs-slide-to="${index}" class="${active}">
      </li>`;
    indicators += indicator;
  }

  const bannerMain = `
  <div
    id="${name}"
    class="carousel slide c-custom-carousel"
    data-bs-interval="false"
    data-bs-pause="hover"
    data-bs-ride="carousel"
    >

    <div class="carousel-inner"> ${sliders}${sliderVideo}</div>
    <ol class="carousel-indicators">${indicators}</ol>

    <button class="carousel-control-prev carousel-control" data-bs-slide="prev" data-bs-target="#${name}" type="button">
      <span class="carousel-control-prev-icon" aria-hidden="true"></span>
      <span class="visually-hidden">Anterior </span>
    </button>
    <button class="carousel-control-next carousel-control" data-bs-slide="next" data-bs-target="#${name}" type="button">
      <span class="carousel-control-next-icon" aria-hidden="true"></span>
      <span class="visually-hidden">Siguiente </span>
    </button>
    
  </div>`;

  bannerContainer.innerHTML = bannerMain;
}
