/* @license GPL-2.0-or-later https://www.drupal.org/licensing/faq */
(function($,_,Backbone,Drupal,drupalSettings,JSON,storage){var options=$.extend(drupalSettings.quickedit,{strings:{quickEdit:Drupal.t('Quick edit')}});var fieldsMetadataQueue=[];var fieldsAvailableQueue=[];var contextualLinksQueue=[];var entityInstancesTracker={};function initQuickEdit(bodyElement){Drupal.quickedit.collections.entities=new Drupal.quickedit.EntityCollection();Drupal.quickedit.collections.fields=new Drupal.quickedit.FieldCollection();Drupal.quickedit.app=new Drupal.quickedit.AppView({el:bodyElement,model:new Drupal.quickedit.AppModel(),entitiesCollection:Drupal.quickedit.collections.entities,fieldsCollection:Drupal.quickedit.collections.fields});}function processEntity(entityElement){var entityID=entityElement.getAttribute('data-quickedit-entity-id');if(!entityInstancesTracker.hasOwnProperty(entityID))entityInstancesTracker[entityID]=0;else entityInstancesTracker[entityID]++;var entityInstanceID=entityInstancesTracker[entityID];entityElement.setAttribute('data-quickedit-entity-instance-id',entityInstanceID);}function initializeField(fieldElement,fieldID,entityID,entityInstanceID){var entity=Drupal.quickedit.collections.entities.findWhere({entityID,entityInstanceID});$(fieldElement).addClass('quickedit-field');var field=new Drupal.quickedit.FieldModel({el:fieldElement,fieldID,id:"".concat(fieldID,"[").concat(entity.get('entityInstanceID'),"]"),entity,metadata:Drupal.quickedit.metadata.get(fieldID),acceptStateChange:_.bind(Drupal.quickedit.app.acceptEditorStateChange,Drupal.quickedit.app)});Drupal.quickedit.collections.fields.add(field);}function loadMissingEditors(callback){var loadedEditors=_.keys(Drupal.quickedit.editors);var missingEditors=[];Drupal.quickedit.collections.fields.each(function(fieldModel){var metadata=Drupal.quickedit.metadata.get(fieldModel.get('fieldID'));if(metadata.access&&_.indexOf(loadedEditors,metadata.editor)===-1){missingEditors.push(metadata.editor);Drupal.quickedit.editors[metadata.editor]=false;}});missingEditors=_.uniq(missingEditors);if(missingEditors.length===0){callback();return;}var loadEditorsAjax=Drupal.ajax({url:Drupal.url('quickedit/attachments'),submit:{'editors[]':missingEditors}});loadEditorsAjax.execute().then(callback);}function initializeEntityContextualLink(contextualLink){var metadata=Drupal.quickedit.metadata;function hasFieldWithPermission(fieldIDs){for(var i=0;i<fieldIDs.length;i++){var fieldID=fieldIDs[i];if(metadata.get(fieldID,'access')===true)return true;}return false;}function allMetadataExists(fieldIDs){return fieldIDs.length===metadata.intersection(fieldIDs).length;}var fields=_.where(fieldsAvailableQueue,{entityID:contextualLink.entityID,entityInstanceID:contextualLink.entityInstanceID});var fieldIDs=_.pluck(fields,'fieldID');if(fieldIDs.length===0)return false;if(hasFieldWithPermission(fieldIDs)){var entityModel=new Drupal.quickedit.EntityModel({el:contextualLink.region,entityID:contextualLink.entityID,entityInstanceID:contextualLink.entityInstanceID,id:"".concat(contextualLink.entityID,"[").concat(contextualLink.entityInstanceID,"]"),label:Drupal.quickedit.metadata.get(contextualLink.entityID,'label')});Drupal.quickedit.collections.entities.add(entityModel);var entityDecorationView=new Drupal.quickedit.EntityDecorationView({el:contextualLink.region,model:entityModel});entityModel.set('entityDecorationView',entityDecorationView);_.each(fields,function(field){initializeField(field.el,field.fieldID,contextualLink.entityID,contextualLink.entityInstanceID);});fieldsAvailableQueue=_.difference(fieldsAvailableQueue,fields);var initContextualLink=_.once(function(){var $links=$(contextualLink.el).find('.contextual-links');var contextualLinkView=new Drupal.quickedit.ContextualLinkView($.extend({el:$('<li class="quickedit"><a href="" role="button" aria-pressed="false"></a></li>').prependTo($links),model:entityModel,appModel:Drupal.quickedit.app.model},options));entityModel.set('contextualLinkView',contextualLinkView);});loadMissingEditors(initContextualLink);return true;}if(allMetadataExists(fieldIDs))return true;return false;}function extractEntityID(fieldID){return fieldID.split('/').slice(0,2).join('/');}function processField(fieldElement){var metadata=Drupal.quickedit.metadata;var fieldID=fieldElement.getAttribute('data-quickedit-field-id');var entityID=extractEntityID(fieldID);var entityElementSelector="[data-quickedit-entity-id=\"".concat(entityID,"\"]");var $entityElement=$(entityElementSelector);if(!$entityElement.length)throw new Error("Quick Edit could not associate the rendered entity field markup (with [data-quickedit-field-id=\"".concat(fieldID,"\"]) with the corresponding rendered entity markup: no parent DOM node found with [data-quickedit-entity-id=\"").concat(entityID,"\"]. This is typically caused by the theme's template for this entity type forgetting to print the attributes."));var entityElement=$(fieldElement).closest($entityElement);if(entityElement.length===0){var $lowestCommonParent=$entityElement.parents().has(fieldElement).first();entityElement=$lowestCommonParent.find($entityElement);}var entityInstanceID=entityElement.get(0).getAttribute('data-quickedit-entity-instance-id');if(!metadata.has(fieldID)){fieldsMetadataQueue.push({el:fieldElement,fieldID,entityID,entityInstanceID});return;}if(metadata.get(fieldID,'access')!==true)return;if(Drupal.quickedit.collections.entities.findWhere({entityID,entityInstanceID}))initializeField(fieldElement,fieldID,entityID,entityInstanceID);else fieldsAvailableQueue.push({el:fieldElement,fieldID,entityID,entityInstanceID});}function deleteContainedModelsAndQueues($context){$context.find('[data-quickedit-entity-id]').addBack('[data-quickedit-entity-id]').each(function(index,entityElement){var entityModel=Drupal.quickedit.collections.entities.findWhere({el:entityElement});if(entityModel){var contextualLinkView=entityModel.get('contextualLinkView');contextualLinkView.undelegateEvents();contextualLinkView.remove();entityModel.get('entityDecorationView').remove();entityModel.destroy();}function hasOtherRegion(contextualLink){return contextualLink.region!==entityElement;}contextualLinksQueue=_.filter(contextualLinksQueue,hasOtherRegion);});$context.find('[data-quickedit-field-id]').addBack('[data-quickedit-field-id]').each(function(index,fieldElement){Drupal.quickedit.collections.fields.chain().filter(function(fieldModel){return fieldModel.get('el')===fieldElement;}).invoke('destroy');function hasOtherFieldElement(field){return field.el!==fieldElement;}fieldsMetadataQueue=_.filter(fieldsMetadataQueue,hasOtherFieldElement);fieldsAvailableQueue=_.filter(fieldsAvailableQueue,hasOtherFieldElement);});}function fetchMissingMetadata(callback){if(fieldsMetadataQueue.length){var fieldIDs=_.pluck(fieldsMetadataQueue,'fieldID');var fieldElementsWithoutMetadata=_.pluck(fieldsMetadataQueue,'el');var entityIDs=_.uniq(_.pluck(fieldsMetadataQueue,'entityID'),true);entityIDs=_.difference(entityIDs,Drupal.quickedit.metadata.intersection(entityIDs));fieldsMetadataQueue=[];$.ajax({url:Drupal.url('quickedit/metadata'),type:'POST',data:{'fields[]':fieldIDs,'entities[]':entityIDs},dataType:'json',success:function success(results){_.each(results,function(fieldMetadata,fieldID){Drupal.quickedit.metadata.add(fieldID,fieldMetadata);});callback(fieldElementsWithoutMetadata);}});}}Drupal.behaviors.quickedit={attach:function attach(context){once('quickedit-init','body').forEach(initQuickEdit);var fields=once('quickedit','[data-quickedit-field-id]',context);if(fields.length===0)return;once('quickedit','[data-quickedit-entity-id]',context).forEach(processEntity);fields.forEach(processField);contextualLinksQueue=_.filter(contextualLinksQueue,function(contextualLink){return !initializeEntityContextualLink(contextualLink);});fetchMissingMetadata(function(fieldElementsWithFreshMetadata){_.each(fieldElementsWithFreshMetadata,processField);contextualLinksQueue=_.filter(contextualLinksQueue,function(contextualLink){return !initializeEntityContextualLink(contextualLink);});});},detach:function detach(context,settings,trigger){if(trigger==='unload')deleteContainedModelsAndQueues($(context));}};Drupal.quickedit={app:null,collections:{entities:null,fields:null},editors:{},metadata:{has:function has(fieldID){return storage.getItem(this._prefixFieldID(fieldID))!==null;},add:function add(fieldID,metadata){storage.setItem(this._prefixFieldID(fieldID),JSON.stringify(metadata));},get:function get(fieldID,key){var metadata=JSON.parse(storage.getItem(this._prefixFieldID(fieldID)));return typeof key==='undefined'?metadata:metadata[key];},_prefixFieldID:function _prefixFieldID(fieldID){return "Drupal.quickedit.metadata.".concat(fieldID);},_unprefixFieldID:function _unprefixFieldID(fieldID){return fieldID.substring(26);},intersection:function intersection(fieldIDs){var prefixedFieldIDs=_.map(fieldIDs,this._prefixFieldID);var intersection=_.intersection(prefixedFieldIDs,_.keys(sessionStorage));return _.map(intersection,this._unprefixFieldID);}}};var permissionsHashKey=Drupal.quickedit.metadata._prefixFieldID('permissionsHash');var permissionsHashValue=storage.getItem(permissionsHashKey);var permissionsHash=drupalSettings.user.permissionsHash;if(permissionsHashValue!==permissionsHash){if(typeof permissionsHash==='string')_.chain(storage).keys().each(function(key){if(key.substring(0,26)==='Drupal.quickedit.metadata.')storage.removeItem(key);});storage.setItem(permissionsHashKey,permissionsHash);}$(document).on('drupalContextualLinkAdded',function(event,data){if(data.$region.is('[data-quickedit-entity-id]')){if(!data.$region.is('[data-quickedit-entity-instance-id]')){once('quickedit',data.$region);processEntity(data.$region.get(0));}var contextualLink={entityID:data.$region.attr('data-quickedit-entity-id'),entityInstanceID:data.$region.attr('data-quickedit-entity-instance-id'),el:data.$el[0],region:data.$region[0]};if(!initializeEntityContextualLink(contextualLink))contextualLinksQueue.push(contextualLink);}});})(jQuery,_,Backbone,Drupal,drupalSettings,window.JSON,window.sessionStorage);;
(function($,Drupal){Drupal.quickedit.util=Drupal.quickedit.util||{};Drupal.quickedit.util.constants={};Drupal.quickedit.util.constants.transitionEnd='transitionEnd.quickedit webkitTransitionEnd.quickedit transitionend.quickedit msTransitionEnd.quickedit oTransitionEnd.quickedit';Drupal.quickedit.util.buildUrl=function(id,urlFormat){var parts=id.split('/');return Drupal.formatString(decodeURIComponent(urlFormat),{'!entity_type':parts[0],'!id':parts[1],'!field_name':parts[2],'!langcode':parts[3],'!view_mode':parts[4]});};Drupal.quickedit.util.networkErrorModal=function(title,message){var $message=$("<div>".concat(message,"</div>"));var networkErrorModal=Drupal.dialog($message.get(0),{title,dialogClass:'quickedit-network-error',buttons:[{text:Drupal.t('OK'),click:function click(){networkErrorModal.close();},primary:true}],create:function create(){$(this).parent().find('.ui-dialog-titlebar-close').remove();},close:function close(event){$(event.target).remove();}});networkErrorModal.showModal();};Drupal.quickedit.util.form={load:function load(options,callback){var fieldID=options.fieldID;var formLoaderAjax=Drupal.ajax({url:Drupal.quickedit.util.buildUrl(fieldID,Drupal.url('quickedit/form/!entity_type/!id/!field_name/!langcode/!view_mode')),submit:{nocssjs:options.nocssjs,reset:options.reset},error:function error(xhr,url){var fieldLabel=Drupal.quickedit.metadata.get(fieldID,'label');var message=Drupal.t('Could not load the form for <q>@field-label</q>, either due to a website problem or a network connection problem.<br>Please try again.',{'@field-label':fieldLabel});Drupal.quickedit.util.networkErrorModal(Drupal.t('Network problem!'),message);var fieldModel=Drupal.quickedit.app.model.get('activeField');fieldModel.set('state','candidate');}});formLoaderAjax.commands.quickeditFieldForm=function(ajax,response,status){callback(response.data,ajax);Drupal.ajax.instances[this.instanceIndex]=null;};formLoaderAjax.execute();},ajaxifySaving:function ajaxifySaving(options,$submit){var settings={url:$submit.closest('form').attr('action'),setClick:true,event:'click.quickedit',progress:false,submit:{nocssjs:options.nocssjs,other_view_modes:options.other_view_modes},success:function success(response,status){var _this=this;Object.keys(response||{}).forEach(function(i){if(response[i].command&&_this.commands[response[i].command])_this.commands[response[i].command](_this,response[i],status);});},base:$submit.attr('id'),element:$submit[0]};return Drupal.ajax(settings);},unajaxifySaving:function unajaxifySaving(ajax){$(ajax.element).off('click.quickedit');}};})(jQuery,Drupal);;
function _typeof(obj){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(obj){return typeof obj;}:function(obj){return obj&&"function"==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj;},_typeof(obj);}(function(Drupal,Backbone){Drupal.quickedit.BaseModel=Backbone.Model.extend({initialize:function initialize(options){this.__initialized=true;return Backbone.Model.prototype.initialize.call(this,options);},set:function set(key,val,options){if(this.__initialized)if(_typeof(key)==='object')key.validate=true;else{if(!options)options={};options.validate=true;}return Backbone.Model.prototype.set.call(this,key,val,options);}});})(Drupal,Backbone);;
(function(Backbone,Drupal){Drupal.quickedit.AppModel=Backbone.Model.extend({defaults:{highlightedField:null,activeField:null,activeModal:null}});})(Backbone,Drupal);;
(function(_,$,Backbone,Drupal){Drupal.quickedit.EntityModel=Drupal.quickedit.BaseModel.extend({defaults:{el:null,entityID:null,entityInstanceID:null,id:null,label:null,fields:null,isActive:false,inTempStore:false,isDirty:false,isCommitting:false,state:'closed',fieldsInTempStore:[],reload:false},initialize:function initialize(){this.set('fields',new Drupal.quickedit.FieldCollection());this.listenTo(this,'change:state',this.stateChange);this.listenTo(this.get('fields'),'change:state',this.fieldStateChange);Drupal.quickedit.BaseModel.prototype.initialize.call(this);},stateChange:function stateChange(entityModel,state,options){var to=state;switch(to){case 'closed':this.set({isActive:false,inTempStore:false,isDirty:false});break;case 'launching':break;case 'opening':entityModel.get('fields').each(function(fieldModel){fieldModel.set('state','candidate',options);});break;case 'opened':this.set('isActive',true);break;case 'committing':var fields=this.get('fields');fields.chain().filter(function(fieldModel){return _.intersection([fieldModel.get('state')],['active']).length;}).each(function(fieldModel){fieldModel.set('state','candidate');});fields.chain().filter(function(fieldModel){return _.intersection([fieldModel.get('state')],Drupal.quickedit.app.changedFieldStates).length;}).each(function(fieldModel){fieldModel.set('state','saving');});break;case 'deactivating':var changedFields=this.get('fields').filter(function(fieldModel){return _.intersection([fieldModel.get('state')],['changed','invalid']).length;});if((changedFields.length||this.get('fieldsInTempStore').length)&&!options.saved&&!options.confirmed){this.set('state','opened',{confirming:true});_.defer(function(){Drupal.quickedit.app.confirmEntityDeactivation(entityModel);});}else{var invalidFields=this.get('fields').filter(function(fieldModel){return _.intersection([fieldModel.get('state')],['invalid']).length;});entityModel.set('reload',this.get('fieldsInTempStore').length||invalidFields.length);entityModel.get('fields').each(function(fieldModel){if(_.intersection([fieldModel.get('state')],['candidate','highlighted']).length)fieldModel.trigger('change:state',fieldModel,fieldModel.get('state'),options);else fieldModel.set('state','candidate',options);});}break;case 'closing':options.reason='stop';this.get('fields').each(function(fieldModel){fieldModel.set({inTempStore:false,state:'inactive'},options);});break;}},_updateInTempStoreAttributes:function _updateInTempStoreAttributes(entityModel,fieldModel){var current=fieldModel.get('state');var previous=fieldModel.previous('state');var fieldsInTempStore=entityModel.get('fieldsInTempStore');if(current==='saved'){entityModel.set('inTempStore',true);fieldModel.set('inTempStore',true);fieldsInTempStore.push(fieldModel.get('fieldID'));fieldsInTempStore=_.uniq(fieldsInTempStore);entityModel.set('fieldsInTempStore',fieldsInTempStore);}else{if(current==='candidate'&&previous==='inactive')fieldModel.set('inTempStore',_.intersection([fieldModel.get('fieldID')],fieldsInTempStore).length>0);}},fieldStateChange:function fieldStateChange(fieldModel,state){var entityModel=this;var fieldState=state;switch(this.get('state')){case 'closed':case 'launching':break;case 'opening':_.defer(function(){entityModel.set('state','opened',{'accept-field-states':Drupal.quickedit.app.readyFieldStates});});break;case 'opened':if(fieldState==='changed')entityModel.set('isDirty',true);else this._updateInTempStoreAttributes(entityModel,fieldModel);break;case 'committing':if(fieldState==='invalid')_.defer(function(){entityModel.set('state','opened',{reason:'invalid'});});else this._updateInTempStoreAttributes(entityModel,fieldModel);var options={'accept-field-states':Drupal.quickedit.app.readyFieldStates};if(entityModel.set('isCommitting',true,options))entityModel.save({success:function success(){entityModel.set({state:'deactivating',isCommitting:false},{saved:true});},error:function error(){entityModel.set('isCommitting',false);entityModel.set('state','opened',{reason:'networkerror'});var message=Drupal.t('Your changes to <q>@entity-title</q> could not be saved, either due to a website problem or a network connection problem.<br>Please try again.',{'@entity-title':entityModel.get('label')});Drupal.quickedit.util.networkErrorModal(Drupal.t('Network problem!'),message);}});break;case 'deactivating':_.defer(function(){entityModel.set('state','closing',{'accept-field-states':Drupal.quickedit.app.readyFieldStates});});break;case 'closing':_.defer(function(){entityModel.set('state','closed',{'accept-field-states':['inactive']});});break;}},save:function save(options){var entityModel=this;var entitySaverAjax=Drupal.ajax({url:Drupal.url("quickedit/entity/".concat(entityModel.get('entityID'))),error:function error(){options.error.call(entityModel);}});entitySaverAjax.commands.quickeditEntitySaved=function(ajax,response,status){entityModel.get('fields').each(function(fieldModel){fieldModel.set('inTempStore',false);});entityModel.set('inTempStore',false);entityModel.set('fieldsInTempStore',[]);if(options.success)options.success.call(entityModel);};entitySaverAjax.options.headers=entitySaverAjax.options.headers||{};entitySaverAjax.options.headers['X-Drupal-Quickedit-CSRF-Token']=drupalSettings.quickedit.csrf_token;entitySaverAjax.execute();},validate:function validate(attrs,options){var acceptedFieldStates=options['accept-field-states']||[];var currentState=this.get('state');var nextState=attrs.state;if(currentState!==nextState){if(_.indexOf(this.constructor.states,nextState)===-1)return "\"".concat(nextState,"\" is an invalid state");if(!this._acceptStateChange(currentState,nextState,options))return 'state change not accepted';if(!this._fieldsHaveAcceptableStates(acceptedFieldStates))return 'state change not accepted because fields are not in acceptable state';}var currentIsCommitting=this.get('isCommitting');var nextIsCommitting=attrs.isCommitting;if(currentIsCommitting===false&&nextIsCommitting===true){if(!this._fieldsHaveAcceptableStates(acceptedFieldStates))return 'isCommitting change not accepted because fields are not in acceptable state';}else{if(currentIsCommitting===true&&nextIsCommitting===true)return 'isCommitting is a mutex, hence only changes are allowed';}},_acceptStateChange:function _acceptStateChange(from,to,context){var accept=true;if(!this.constructor.followsStateSequence(from,to)){accept=false;if(from==='closing'&&to==='closed')accept=true;else if(from==='committing'&&to==='opened'&&context.reason&&(context.reason==='invalid'||context.reason==='networkerror'))accept=true;else if(from==='deactivating'&&to==='opened'&&context.confirming)accept=true;else{if(from==='opened'&&to==='deactivating'&&context.confirmed)accept=true;}}return accept;},_fieldsHaveAcceptableStates:function _fieldsHaveAcceptableStates(acceptedFieldStates){var accept=true;if(acceptedFieldStates.length>0){var fieldStates=this.get('fields').pluck('state')||[];if(_.difference(fieldStates,acceptedFieldStates).length)accept=false;}return accept;},destroy:function destroy(options){Drupal.quickedit.BaseModel.prototype.destroy.call(this,options);this.stopListening();this.get('fields').reset();},sync:function sync(){}},{states:['closed','launching','opening','opened','committing','deactivating','closing'],followsStateSequence:function followsStateSequence(from,to){return _.indexOf(this.states,from)<_.indexOf(this.states,to);}});Drupal.quickedit.EntityCollection=Backbone.Collection.extend({model:Drupal.quickedit.EntityModel});})(_,jQuery,Backbone,Drupal);;
(function(_,Backbone,Drupal){Drupal.quickedit.FieldModel=Drupal.quickedit.BaseModel.extend({defaults:{el:null,fieldID:null,id:null,entity:null,metadata:null,acceptStateChange:null,logicalFieldID:null,state:'inactive',isChanged:false,inTempStore:false,html:null,htmlForOtherViewModes:null},initialize:function initialize(options){this.set('html',options.el.outerHTML);this.get('entity').get('fields').add(this);this.set('logicalFieldID',this.get('fieldID').split('/').slice(0,4).join('/'));Drupal.quickedit.BaseModel.prototype.initialize.call(this,options);},destroy:function destroy(options){if(this.get('state')!=='inactive')throw new Error('FieldModel cannot be destroyed if it is not inactive state.');Drupal.quickedit.BaseModel.prototype.destroy.call(this,options);},sync:function sync(){},validate:function validate(attrs,options){var current=this.get('state');var next=attrs.state;if(current!==next){if(_.indexOf(this.constructor.states,next)===-1)return "\"".concat(next,"\" is an invalid state");if(!this.get('acceptStateChange')(current,next,options,this))return 'state change not accepted';}},getEntityID:function getEntityID(){return this.get('fieldID').split('/').slice(0,2).join('/');},getViewMode:function getViewMode(){return this.get('fieldID').split('/').pop();},findOtherViewModes:function findOtherViewModes(){var currentField=this;var otherViewModes=[];Drupal.quickedit.collections.fields.where({logicalFieldID:currentField.get('logicalFieldID')}).forEach(function(field){if(field!==currentField&&field.get('fieldID')!==currentField.get('fieldID'))otherViewModes.push(field.getViewMode());});return otherViewModes;}},{states:['inactive','candidate','highlighted','activating','active','changed','saving','saved','invalid'],followsStateSequence:function followsStateSequence(from,to){return _.indexOf(this.states,from)<_.indexOf(this.states,to);}});Drupal.quickedit.FieldCollection=Backbone.Collection.extend({model:Drupal.quickedit.FieldModel});})(_,Backbone,Drupal);;
(function(Backbone,Drupal){Drupal.quickedit.EditorModel=Backbone.Model.extend({defaults:{originalValue:null,currentValue:null,validationErrors:null}});})(Backbone,Drupal);;
(function($,_,Backbone,Drupal){var reload=false;Drupal.quickedit.AppView=Backbone.View.extend({initialize:function initialize(options){this.activeFieldStates=['activating','active'];this.singleFieldStates=['highlighted','activating','active'];this.changedFieldStates=['changed','saving','saved','invalid'];this.readyFieldStates=['candidate','highlighted'];this.listenTo(options.entitiesCollection,'change:state',this.appStateChange);this.listenTo(options.entitiesCollection,'change:isActive',this.enforceSingleActiveEntity);this.listenTo(options.fieldsCollection,'change:state',this.editorStateChange);this.listenTo(options.fieldsCollection,'change:html',this.renderUpdatedField);this.listenTo(options.fieldsCollection,'change:html',this.propagateUpdatedField);this.listenTo(options.fieldsCollection,'add',this.rerenderedFieldToCandidate);this.listenTo(options.fieldsCollection,'destroy',this.teardownEditor);},appStateChange:function appStateChange(entityModel,state){var app=this;var entityToolbarView;switch(state){case 'launching':reload=false;entityToolbarView=new Drupal.quickedit.EntityToolbarView({model:entityModel,appModel:this.model});entityModel.toolbarView=entityToolbarView;entityModel.get('fields').each(function(fieldModel){app.setupEditor(fieldModel);});_.defer(function(){entityModel.set('state','opening');});break;case 'closed':entityToolbarView=entityModel.toolbarView;entityModel.get('fields').each(function(fieldModel){app.teardownEditor(fieldModel);});if(entityToolbarView){entityToolbarView.remove();delete entityModel.toolbarView;}if(reload){reload=false;window.location.reload();}break;}},acceptEditorStateChange:function acceptEditorStateChange(from,to,context,fieldModel){var accept=true;if(context&&(context.reason==='stop'||context.reason==='rerender')){if(from==='candidate'&&to==='inactive')accept=true;}else{if(!Drupal.quickedit.FieldModel.followsStateSequence(from,to)){accept=false;if(_.indexOf(this.activeFieldStates,from)!==-1&&to==='candidate')accept=true;else if((from==='changed'||from==='invalid')&&to==='candidate')accept=true;else if(from==='highlighted'&&to==='candidate')accept=true;else if(from==='saved'&&to==='candidate')accept=true;else if(from==='invalid'&&to==='saving')accept=true;else{if(from==='invalid'&&to==='activating')accept=true;}}if(accept){var activeField;var activeFieldState;if((this.readyFieldStates.indexOf(from)!==-1||from==='invalid')&&this.activeFieldStates.indexOf(to)!==-1){activeField=this.model.get('activeField');if(activeField&&activeField!==fieldModel){activeFieldState=activeField.get('state');if(this.activeFieldStates.indexOf(activeFieldState)!==-1)activeField.set('state','candidate');else{if(activeFieldState==='changed'||activeFieldState==='invalid')activeField.set('state','saving');}if(from==='invalid'){this.model.set('activeField',fieldModel);accept=false;}}}else if(_.indexOf(this.activeFieldStates,from)!==-1&&to==='candidate'){if(context&&context.reason==='mouseleave')accept=false;}else{if((from==='changed'||from==='invalid')&&to==='candidate')if(context&&context.reason==='mouseleave')accept=false;else{if(context&&context.confirmed)accept=true;}}}}return accept;},setupEditor:function setupEditor(fieldModel){var entityModel=fieldModel.get('entity');var entityToolbarView=entityModel.toolbarView;var fieldToolbarRoot=entityToolbarView.getToolbarRoot();var editorName=fieldModel.get('metadata').editor;var editorModel=new Drupal.quickedit.EditorModel();var editorView=new Drupal.quickedit.editors[editorName]({el:$(fieldModel.get('el')),model:editorModel,fieldModel});var toolbarView=new Drupal.quickedit.FieldToolbarView({el:fieldToolbarRoot,model:fieldModel,$editedElement:$(editorView.getEditedElement()),editorView,entityModel});var decorationView=new Drupal.quickedit.FieldDecorationView({el:$(editorView.getEditedElement()),model:fieldModel,editorView});fieldModel.editorView=editorView;fieldModel.toolbarView=toolbarView;fieldModel.decorationView=decorationView;},teardownEditor:function teardownEditor(fieldModel){if(typeof fieldModel.editorView==='undefined')return;fieldModel.toolbarView.remove();delete fieldModel.toolbarView;fieldModel.decorationView.remove();delete fieldModel.decorationView;fieldModel.editorView.remove();delete fieldModel.editorView;},confirmEntityDeactivation:function confirmEntityDeactivation(entityModel){var that=this;var discardDialog;function closeDiscardDialog(action){discardDialog.close(action);that.model.set('activeModal',null);if(action==='save')entityModel.set('state','committing',{confirmed:true});else{entityModel.set('state','deactivating',{confirmed:true});if(entityModel.get('reload')){reload=true;entityModel.set('reload',false);}}}if(!this.model.get('activeModal')){var $unsavedChanges=$("<div>".concat(Drupal.t('You have unsaved changes'),"</div>"));discardDialog=Drupal.dialog($unsavedChanges.get(0),{title:Drupal.t('Discard changes?'),dialogClass:'quickedit-discard-modal',resizable:false,buttons:[{text:Drupal.t('Save'),click:function click(){closeDiscardDialog('save');},primary:true},{text:Drupal.t('Discard changes'),click:function click(){closeDiscardDialog('discard');}}],closeOnEscape:false,create:function create(){$(this).parent().find('.ui-dialog-titlebar-close').remove();},beforeClose:false,close:function close(event){$(event.target).remove();}});this.model.set('activeModal',discardDialog);discardDialog.showModal();}},editorStateChange:function editorStateChange(fieldModel,state){var from=fieldModel.previous('state');var to=state;if(_.indexOf(this.singleFieldStates,to)!==-1&&this.model.get('highlightedField')!==fieldModel)this.model.set('highlightedField',fieldModel);else{if(this.model.get('highlightedField')===fieldModel&&to==='candidate')this.model.set('highlightedField',null);}if(_.indexOf(this.activeFieldStates,to)!==-1&&this.model.get('activeField')!==fieldModel)this.model.set('activeField',fieldModel);else{if(this.model.get('activeField')===fieldModel&&to==='candidate'){if(from==='changed'||from==='invalid')fieldModel.editorView.revert();this.model.set('activeField',null);}}},renderUpdatedField:function renderUpdatedField(fieldModel,html,options){var $fieldWrapper=$(fieldModel.get('el'));var $context=$fieldWrapper.parent();var renderField=function renderField(){fieldModel.destroy();$fieldWrapper.replaceWith(html);Drupal.attachBehaviors($context.get(0));};if(!options.propagation)_.defer(function(){fieldModel.set('state','candidate');_.defer(function(){fieldModel.set('state','inactive',{reason:'rerender'});renderField();});});else renderField();},propagateUpdatedField:function propagateUpdatedField(updatedField,html,options){if(options.propagation)return;var htmlForOtherViewModes=updatedField.get('htmlForOtherViewModes');Drupal.quickedit.collections.fields.where({logicalFieldID:updatedField.get('logicalFieldID')}).forEach(function(field){if(field===updatedField){}else if(field.getViewMode()===updatedField.getViewMode())field.set('html',updatedField.get('html'));else{if(field.getViewMode() in htmlForOtherViewModes)field.set('html',htmlForOtherViewModes[field.getViewMode()],{propagation:true});}});},rerenderedFieldToCandidate:function rerenderedFieldToCandidate(fieldModel){var activeEntity=Drupal.quickedit.collections.entities.findWhere({isActive:true});if(!activeEntity)return;if(fieldModel.get('entity')===activeEntity){this.setupEditor(fieldModel);fieldModel.set('state','candidate');}},enforceSingleActiveEntity:function enforceSingleActiveEntity(changedEntityModel){if(changedEntityModel.get('isActive')===false)return;changedEntityModel.collection.chain().filter(function(entityModel){return entityModel.get('isActive')===true&&entityModel!==changedEntityModel;}).each(function(entityModel){entityModel.set('state','deactivating');});}});})(jQuery,_,Backbone,Drupal);;
(function($,Backbone,Drupal){Drupal.quickedit.FieldDecorationView=Backbone.View.extend({_widthAttributeIsEmpty:null,events:{'mouseenter.quickedit':'onMouseEnter','mouseleave.quickedit':'onMouseLeave',click:'onClick','tabIn.quickedit':'onMouseEnter','tabOut.quickedit':'onMouseLeave'},initialize:function initialize(options){this.editorView=options.editorView;this.listenTo(this.model,'change:state',this.stateChange);this.listenTo(this.model,'change:isChanged change:inTempStore',this.renderChanged);},remove:function remove(){this.setElement();Backbone.View.prototype.remove.call(this);},stateChange:function stateChange(model,state){var from=model.previous('state');var to=state;switch(to){case 'inactive':this.undecorate();break;case 'candidate':this.decorate();if(from!=='inactive'){this.stopHighlight();if(from!=='highlighted'){this.model.set('isChanged',false);this.stopEdit();}}this._unpad();break;case 'highlighted':this.startHighlight();break;case 'activating':this.prepareEdit();break;case 'active':if(from!=='activating')this.prepareEdit();if(this.editorView.getQuickEditUISettings().padding)this._pad();break;case 'changed':this.model.set('isChanged',true);break;case 'saving':break;case 'saved':break;case 'invalid':break;}},renderChanged:function renderChanged(){this.$el.toggleClass('quickedit-changed',this.model.get('isChanged')||this.model.get('inTempStore'));},onMouseEnter:function onMouseEnter(event){var that=this;that.model.set('state','highlighted');event.stopPropagation();},onMouseLeave:function onMouseLeave(event){var that=this;that.model.set('state','candidate',{reason:'mouseleave'});event.stopPropagation();},onClick:function onClick(event){this.model.set('state','activating');event.preventDefault();event.stopPropagation();},decorate:function decorate(){this.$el.addClass('quickedit-candidate quickedit-editable');},undecorate:function undecorate(){this.$el.removeClass('quickedit-candidate quickedit-editable quickedit-highlighted quickedit-editing');},startHighlight:function startHighlight(){var that=this;that.$el.addClass('quickedit-highlighted');},stopHighlight:function stopHighlight(){this.$el.removeClass('quickedit-highlighted');},prepareEdit:function prepareEdit(){this.$el.addClass('quickedit-editing');if(this.editorView.getQuickEditUISettings().popup)this.$el.addClass('quickedit-editor-is-popup');},stopEdit:function stopEdit(){this.$el.removeClass('quickedit-highlighted quickedit-editing');if(this.editorView.getQuickEditUISettings().popup)this.$el.removeClass('quickedit-editor-is-popup');$('.quickedit-candidate').addClass('quickedit-editable');},_pad:function _pad(){if(this.$el.data('quickedit-padded'))return;var self=this;if(this.$el[0].style.width===''){this._widthAttributeIsEmpty=true;this.$el.addClass('quickedit-animate-disable-width').css('width',this.$el.width());}var posProp=this._getPositionProperties(this.$el);setTimeout(function(){self.$el.removeClass('quickedit-animate-disable-width');self.$el.css({position:'relative',top:"".concat(posProp.top-5,"px"),left:"".concat(posProp.left-5,"px"),'padding-top':"".concat(posProp['padding-top']+5,"px"),'padding-left':"".concat(posProp['padding-left']+5,"px"),'padding-right':"".concat(posProp['padding-right']+5,"px"),'padding-bottom':"".concat(posProp['padding-bottom']+5,"px"),'margin-bottom':"".concat(posProp['margin-bottom']-10,"px")}).data('quickedit-padded',true);},0);},_unpad:function _unpad(){if(!this.$el.data('quickedit-padded'))return;var self=this;if(this._widthAttributeIsEmpty)this.$el.addClass('quickedit-animate-disable-width').css('width','');var posProp=this._getPositionProperties(this.$el);setTimeout(function(){self.$el.removeClass('quickedit-animate-disable-width');self.$el.css({position:'relative',top:"".concat(posProp.top+5,"px"),left:"".concat(posProp.left+5,"px"),'padding-top':"".concat(posProp['padding-top']-5,"px"),'padding-left':"".concat(posProp['padding-left']-5,"px"),'padding-right':"".concat(posProp['padding-right']-5,"px"),'padding-bottom':"".concat(posProp['padding-bottom']-5,"px"),'margin-bottom':"".concat(posProp['margin-bottom']+10,"px")});},0);this.$el.removeData('quickedit-padded');},_getPositionProperties:function _getPositionProperties($e){var p;var r={};var props=['top','left','bottom','right','padding-top','padding-left','padding-right','padding-bottom','margin-bottom'];var propCount=props.length;for(var i=0;i<propCount;i++){p=props[i];r[p]=parseInt(this._replaceBlankPosition($e.css(p)),10);}return r;},_replaceBlankPosition:function _replaceBlankPosition(pos){if(pos==='auto'||!pos)pos='0px';return pos;}});})(jQuery,Backbone,Drupal);;
(function(Drupal,$,Backbone){Drupal.quickedit.EntityDecorationView=Backbone.View.extend({initialize:function initialize(){this.listenTo(this.model,'change',this.render);},render:function render(){this.$el.toggleClass('quickedit-entity-active',this.model.get('isActive'));},remove:function remove(){this.setElement(null);Backbone.View.prototype.remove.call(this);}});})(Drupal,jQuery,Backbone);;
(function($,_,Backbone,Drupal,debounce,Popper){Drupal.quickedit.EntityToolbarView=Backbone.View.extend({_fieldToolbarRoot:null,events:function events(){var map={'click button.action-save':'onClickSave','click button.action-cancel':'onClickCancel',mouseenter:'onMouseenter'};return map;},initialize:function initialize(options){var that=this;this.appModel=options.appModel;this.$entity=$(this.model.get('el'));this.listenTo(this.model,'change:isActive change:isDirty change:state',this.render);this.listenTo(this.appModel,'change:highlightedField change:activeField',this.render);this.listenTo(this.model.get('fields'),'change:state',this.fieldStateChange);$(window).on('resize.quickedit scroll.quickedit drupalViewportOffsetChange.quickedit',debounce($.proxy(this.windowChangeHandler,this),150));$(document).on('drupalViewportOffsetChange.quickedit',function(event,offsets){if(that.$fence)that.$fence.css(offsets);});var $toolbar=this.buildToolbarEl();this.setElement($toolbar);this._fieldToolbarRoot=$toolbar.find('.quickedit-toolbar-field').get(0);this.render();},render:function render(){if(this.model.get('isActive')){var $body=$('body');if($body.children('#quickedit-entity-toolbar').length===0)$body.append(this.$el);if($body.children('#quickedit-toolbar-fence').length===0)this.$fence=$(Drupal.theme('quickeditEntityToolbarFence')).css(Drupal.displace()).appendTo($body);this.label();this.show('ops');this.position();}var $button=this.$el.find('.quickedit-button.action-save');var isDirty=this.model.get('isDirty');switch(this.model.get('state')){case 'opened':$button[0].textContent=Drupal.t('Save');$button.removeClass('action-saving icon-throbber icon-end').removeAttr('disabled').attr('aria-hidden',!isDirty);break;case 'committing':$button[0].textContent=Drupal.t('Saving');$button.addClass('action-saving icon-throbber icon-end').attr('disabled','disabled');break;default:$button.attr('aria-hidden',true);break;}return this;},remove:function remove(){this.$fence.remove();$(window).off('resize.quickedit scroll.quickedit drupalViewportOffsetChange.quickedit');$(document).off('drupalViewportOffsetChange.quickedit');Backbone.View.prototype.remove.call(this);},windowChangeHandler:function windowChangeHandler(event){this.position();},fieldStateChange:function fieldStateChange(model,state){switch(state){case 'active':this.render();break;case 'invalid':this.render();break;}},position:function position(element){clearTimeout(this.timer);var that=this;var edge=document.documentElement.dir==='rtl'?'right':'left';var delay=0;var check=0;var horizontalPadding=0;var of;var activeField;var highlightedField;do{switch(check){case 0:of=element;break;case 1:activeField=Drupal.quickedit.app.model.get('activeField');of=activeField&&activeField.editorView&&activeField.editorView.$formContainer&&activeField.editorView.$formContainer.find('.quickedit-form');break;case 2:of=activeField&&activeField.editorView&&activeField.editorView.getEditedElement();if(activeField&&activeField.editorView&&activeField.editorView.getQuickEditUISettings().padding)horizontalPadding=5;break;case 3:highlightedField=Drupal.quickedit.app.model.get('highlightedField');of=highlightedField&&highlightedField.editorView&&highlightedField.editorView.getEditedElement();delay=250;break;default:var fieldModels=this.model.get('fields').models;var topMostPosition=1000000;var topMostField=null;for(var i=0;i<fieldModels.length;i++){var pos=fieldModels[i].get('el').getBoundingClientRect().top;if(pos<topMostPosition){topMostPosition=pos;topMostField=fieldModels[i];}}of=topMostField.get('el');delay=50;break;}check++;}while(!of);function refinePopper(_ref){var state=_ref.state;var isBelow=state.placement.split('-')[0]==='bottom';var classListMethod=isBelow?'add':'remove';state.elements.popper.classList[classListMethod]('quickedit-toolbar-pointer-top');}function positionToolbar(){var popperElement=that.el;var referenceElement=of;var boundariesElement=that.$fence[0];var popperedge=edge==='left'?'start':'end';if(referenceElement!==undefined)if(!popperElement.classList.contains('js-popper-processed')){that.popper=Popper.createPopper(referenceElement,popperElement,{placement:"top-".concat(popperedge),modifiers:[{name:'flip',options:{boundary:boundariesElement}},{name:'preventOverflow',options:{boundary:boundariesElement,tether:false,altAxis:true,padding:{top:5,bottom:5}}},{name:'computeStyles',options:{adaptive:false}},{name:'refinePopper',phase:'write',enabled:true,fn:refinePopper}]});popperElement.classList.add('js-popper-processed');}else{that.popper.state.elements.reference=referenceElement[0]?referenceElement[0]:referenceElement;that.popper.forceUpdate();}that.$el.css({'max-width':document.documentElement.clientWidth<450?document.documentElement.clientWidth:450,'min-width':document.documentElement.clientWidth<240?document.documentElement.clientWidth:240,width:'100%'});}this.timer=setTimeout(function(){_.defer(positionToolbar);},delay);},onClickSave:function onClickSave(event){event.stopPropagation();event.preventDefault();this.model.set('state','committing');},onClickCancel:function onClickCancel(event){event.preventDefault();this.model.set('state','deactivating');},onMouseenter:function onMouseenter(event){clearTimeout(this.timer);},buildToolbarEl:function buildToolbarEl(){var $toolbar=$(Drupal.theme('quickeditEntityToolbar',{id:'quickedit-entity-toolbar'}));$toolbar.find('.quickedit-toolbar-entity').prepend(Drupal.theme('quickeditToolgroup',{classes:['ops'],buttons:[{label:Drupal.t('Save'),type:'submit',classes:'action-save quickedit-button icon',attributes:{'aria-hidden':true}},{label:Drupal.t('Close'),classes:'action-cancel quickedit-button icon icon-close icon-only'}]}));$toolbar.css({left:this.$entity.offset().left,top:this.$entity.offset().top});return $toolbar;},getToolbarRoot:function getToolbarRoot(){return this._fieldToolbarRoot;},label:function label(){var label='';var entityLabel=this.model.get('label');var activeField=Drupal.quickedit.app.model.get('activeField');var activeFieldLabel=activeField&&activeField.get('metadata').label;var highlightedField=Drupal.quickedit.app.model.get('highlightedField');var highlightedFieldLabel=highlightedField&&highlightedField.get('metadata').label;if(activeFieldLabel)label=Drupal.theme('quickeditEntityToolbarLabel',{entityLabel,fieldLabel:activeFieldLabel});else if(highlightedFieldLabel)label=Drupal.theme('quickeditEntityToolbarLabel',{entityLabel,fieldLabel:highlightedFieldLabel});else label=Drupal.checkPlain(entityLabel);this.$el.find('.quickedit-toolbar-label').html(label);},addClass:function addClass(toolgroup,classes){this._find(toolgroup).addClass(classes);},removeClass:function removeClass(toolgroup,classes){this._find(toolgroup).removeClass(classes);},_find:function _find(toolgroup){return this.$el.find(".quickedit-toolbar .quickedit-toolgroup.".concat(toolgroup));},show:function show(toolgroup){this.$el.removeClass('quickedit-animate-invisible');}});})(jQuery,_,Backbone,Drupal,Drupal.debounce,Popper);;
(function($,Backbone,Drupal){Drupal.quickedit.ContextualLinkView=Backbone.View.extend({events:function events(){function touchEndToClick(event){event.preventDefault();event.target.click();}return {'click a':function clickA(event){event.preventDefault();this.model.set('state','launching');},'touchEnd a':touchEndToClick};},initialize:function initialize(options){this.$el.find('a').each(function(index,element){element.textContent=options.strings.quickEdit;});this.render();this.listenTo(this.model,'change:isActive',this.render);},render:function render(entityModel,isActive){this.$el.find('a').attr('aria-pressed',isActive);this.$el.closest('.contextual').toggle(!isActive);return this;}});})(jQuery,Backbone,Drupal);;
(function($,_,Backbone,Drupal){Drupal.quickedit.FieldToolbarView=Backbone.View.extend({$editedElement:null,editorView:null,_id:null,initialize:function initialize(options){this.$editedElement=options.$editedElement;this.editorView=options.editorView;this.$root=this.$el;this._id="quickedit-toolbar-for-".concat(this.model.id.replace(/[/[\]]/g,'_'));this.listenTo(this.model,'change:state',this.stateChange);},render:function render(){this.setElement($(Drupal.theme('quickeditFieldToolbar',{id:this._id})));this.$el.prependTo(this.$root);return this;},stateChange:function stateChange(model,state){var from=model.previous('state');var to=state;switch(to){case 'inactive':break;case 'candidate':if(from!=='inactive'&&from!=='highlighted'){this.$el.remove();this.setElement();}break;case 'highlighted':break;case 'activating':this.render();if(this.editorView.getQuickEditUISettings().fullWidthToolbar)this.$el.addClass('quickedit-toolbar-fullwidth');if(this.editorView.getQuickEditUISettings().unifiedToolbar)this.insertWYSIWYGToolGroups();break;case 'active':break;case 'changed':break;case 'saving':break;case 'saved':break;case 'invalid':break;}},insertWYSIWYGToolGroups:function insertWYSIWYGToolGroups(){this.$el.append(Drupal.theme('quickeditToolgroup',{id:this.getFloatedWysiwygToolgroupId(),classes:['wysiwyg-floated','quickedit-animate-slow','quickedit-animate-invisible','quickedit-animate-delay-veryfast'],buttons:[]})).append(Drupal.theme('quickeditToolgroup',{id:this.getMainWysiwygToolgroupId(),classes:['wysiwyg-main','quickedit-animate-slow','quickedit-animate-invisible','quickedit-animate-delay-veryfast'],buttons:[]}));this.show('wysiwyg-floated');this.show('wysiwyg-main');},getId:function getId(){return "quickedit-toolbar-for-".concat(this._id);},getFloatedWysiwygToolgroupId:function getFloatedWysiwygToolgroupId(){return "quickedit-wysiwyg-floated-toolgroup-for-".concat(this._id);},getMainWysiwygToolgroupId:function getMainWysiwygToolgroupId(){return "quickedit-wysiwyg-main-toolgroup-for-".concat(this._id);},_find:function _find(toolgroup){return this.$el.find(".quickedit-toolgroup.".concat(toolgroup));},show:function show(toolgroup){var $group=this._find(toolgroup);$group.on(Drupal.quickedit.util.constants.transitionEnd,function(event){$group.off(Drupal.quickedit.util.constants.transitionEnd);});window.setTimeout(function(){$group.removeClass('quickedit-animate-invisible');},0);}});})(jQuery,_,Backbone,Drupal);;
(function($,Backbone,Drupal){Drupal.quickedit.EditorView=Backbone.View.extend({initialize:function initialize(options){this.fieldModel=options.fieldModel;this.listenTo(this.fieldModel,'change:state',this.stateChange);},remove:function remove(){this.setElement();Backbone.View.prototype.remove.call(this);},getEditedElement:function getEditedElement(){return this.$el;},getQuickEditUISettings:function getQuickEditUISettings(){return {padding:false,unifiedToolbar:false,fullWidthToolbar:false,popup:false};},stateChange:function stateChange(fieldModel,state){var from=fieldModel.previous('state');var to=state;switch(to){case 'inactive':break;case 'candidate':if(from==='invalid')this.removeValidationErrors();break;case 'highlighted':break;case 'activating':var loadDependencies=function loadDependencies(callback){callback();};loadDependencies(function(){fieldModel.set('state','active');});break;case 'active':break;case 'changed':break;case 'saving':if(from==='invalid')this.removeValidationErrors();this.save();break;case 'saved':break;case 'invalid':this.showValidationErrors();break;}},revert:function revert(){},save:function save(){var fieldModel=this.fieldModel;var editorModel=this.model;var backstageId="quickedit_backstage-".concat(this.fieldModel.id.replace(/[/[\]_\s]/g,'-'));function fillAndSubmitForm(value){var $form=$("#".concat(backstageId)).find('form');$form.find(':input[type!="hidden"][type!="submit"]:not(select)').not('[name$="\\[summary\\]"]').val(value);$form.find('.quickedit-form-submit').trigger('click.quickedit');}var formOptions={fieldID:this.fieldModel.get('fieldID'),$el:this.$el,nocssjs:true,other_view_modes:fieldModel.findOtherViewModes(),reset:!this.fieldModel.get('entity').get('inTempStore')};var self=this;Drupal.quickedit.util.form.load(formOptions,function(form,ajax){var $backstage=$(Drupal.theme('quickeditBackstage',{id:backstageId})).appendTo('body');var $form=$(form).appendTo($backstage);$form.prop('novalidate',true);var $submit=$form.find('.quickedit-form-submit');self.formSaveAjax=Drupal.quickedit.util.form.ajaxifySaving(formOptions,$submit);function removeHiddenForm(){Drupal.quickedit.util.form.unajaxifySaving(self.formSaveAjax);delete self.formSaveAjax;$backstage.remove();}self.formSaveAjax.commands.quickeditFieldFormSaved=function(ajax,response,status){removeHiddenForm();fieldModel.set('state','saved');fieldModel.set('htmlForOtherViewModes',response.other_view_modes);fieldModel.set('html',response.data);};self.formSaveAjax.commands.quickeditFieldFormValidationErrors=function(ajax,response,status){removeHiddenForm();editorModel.set('validationErrors',response.data);fieldModel.set('state','invalid');};self.formSaveAjax.commands.quickeditFieldForm=function(){};fillAndSubmitForm(editorModel.get('currentValue'));});},showValidationErrors:function showValidationErrors(){var $errors=$('<div class="quickedit-validation-errors"></div>').append(this.model.get('validationErrors'));this.getEditedElement().addClass('quickedit-validation-error').after($errors);},removeValidationErrors:function removeValidationErrors(){this.getEditedElement().removeClass('quickedit-validation-error').next('.quickedit-validation-errors').remove();}});})(jQuery,Backbone,Drupal);;
(function($,Drupal){Drupal.theme.quickeditBackstage=function(settings){var html='';html+="<div id=\"".concat(settings.id,"\"></div>");return html;};Drupal.theme.quickeditEntityToolbar=function(settings){var html='';html+="<div id=\"".concat(settings.id,"\" class=\"quickedit quickedit-toolbar-container clearfix\">");html+='<i class="quickedit-toolbar-pointer"></i>';html+='<div class="quickedit-toolbar-content">';html+='<div class="quickedit-toolbar quickedit-toolbar-entity clearfix icon icon-pencil">';html+='<div class="quickedit-toolbar-label"></div>';html+='</div>';html+='<div class="quickedit-toolbar quickedit-toolbar-field clearfix"></div>';html+='</div><div class="quickedit-toolbar-lining"></div></div>';return html;};Drupal.theme.quickeditEntityToolbarLabel=function(settings){return "<span class=\"field\">".concat(Drupal.checkPlain(settings.fieldLabel),"</span>").concat(Drupal.checkPlain(settings.entityLabel));};Drupal.theme.quickeditEntityToolbarFence=function(){return '<div id="quickedit-toolbar-fence"></div>';};Drupal.theme.quickeditFieldToolbar=function(settings){return "<div id=\"".concat(settings.id,"\"></div>");};Drupal.theme.quickeditToolgroup=function(settings){var classes=settings.classes||[];classes.unshift('quickedit-toolgroup');var html='';html+="<div class=\"".concat(classes.join(' '),"\"");if(settings.id)html+=" id=\"".concat(settings.id,"\"");html+='>';html+=Drupal.theme('quickeditButtons',{buttons:settings.buttons});html+='</div>';return html;};Drupal.theme.quickeditButtons=function(settings){var html='';var _loop=function _loop(i){var button=settings.buttons[i];if(!button.hasOwnProperty('type'))button.type='button';var attributes=[];var attrMap=settings.buttons[i].attributes||{};Object.keys(attrMap).forEach(function(attr){attributes.push(attr+(attrMap[attr]?"=\"".concat(attrMap[attr],"\""):''));});html+="<button type=\"".concat(button.type,"\" class=\"").concat(button.classes,"\" ").concat(attributes.join(' '),">").concat(button.label,"</button>");};for(var i=0;i<settings.buttons.length;i++)_loop(i);return html;};Drupal.theme.quickeditFormContainer=function(settings){var html='';html+="<div id=\"".concat(settings.id,"\" class=\"quickedit-form-container\">");html+='  <div class="quickedit-form">';html+='    <div class="placeholder">';html+=settings.loadingMsg;html+='    </div>';html+='  </div>';html+='</div>';return html;};Drupal.theme.quickeditImageErrors=function(settings){return "<div class=\"quickedit-image-errors\">".concat(settings.errors,"</div>");};Drupal.theme.quickeditImageDropzone=function(settings){return "<div class=\"quickedit-image-dropzone ".concat(settings.state,"\">")+'  <i class="quickedit-image-icon"></i>'+"  <span class=\"quickedit-image-text\">".concat(settings.text,"</span>")+'</div>';};Drupal.theme.quickeditImageToolbar=function(settings){var html='<form class="quickedit-image-field-info">';if(settings.alt_field)html+="<div><label for=\"alt\" class=\"".concat(settings.alt_field_required?'required':'',"\">").concat(Drupal.t('Alternative text'),"</label>")+"<input type=\"text\" placeholder=\"".concat(settings.alt,"\" value=\"").concat(settings.alt,"\" name=\"alt\" ").concat(settings.alt_field_required?'required':'',"/>")+'  </div>';if(settings.title_field)html+="<div><label for=\"title\" class=\"".concat(settings.title_field_required?'form-required':'',"\">").concat(Drupal.t('Title'),"</label>")+"<input type=\"text\" placeholder=\"".concat(settings.title,"\" value=\"").concat(settings.title,"\" name=\"title\" ").concat(settings.title_field_required?'required':'',"/>")+'</div>';html+='</form>';return html;};})(jQuery,Drupal);;
(function($,Drupal,drupalSettings){let activeItem=Drupal.url(drupalSettings.path.currentPath);$.fn.drupalToolbarMenuHorizontal=function(){let currentPath=drupalSettings.path.currentPath;const menu=once('toolbar-menu-horizontal',this);if(menu.length){const $menu=$(menu);if(activeItem){const count=currentPath.split('/').length;for(let i=0;i<count;i++){const $menuItem=$menu.find(`a[data-drupal-link-system-path="${currentPath}"]`);if($menuItem.length!==0){$menuItem.closest('a').addClass('is-active');break;}const lastIndex=currentPath.lastIndexOf('/');currentPath=currentPath.slice(0,lastIndex);}}}};$.fn.drupalToolbarMenu=function(){const ui={handleOpen:Drupal.t('Extend'),handleClose:Drupal.t('Collapse')};function toggleList($item,switcher){const $toggle=$item.children('.toolbar-box').children('.toolbar-handle');switcher=typeof switcher!=='undefined'?switcher:!$item.hasClass('open');$item.toggleClass('open',switcher);$toggle.toggleClass('open',switcher);$toggle.find('.action').each((index,element)=>{element.textContent=switcher?ui.handleClose:ui.handleOpen;});}function toggleClickHandler(event){const $toggle=$(event.target);const $item=$toggle.closest('li');toggleList($item);const $openItems=$item.siblings().filter('.open');toggleList($openItems,false);}function linkClickHandler(event){if(!Drupal.toolbar.models.toolbarModel.get('isFixed'))Drupal.toolbar.models.toolbarModel.set('activeTab',null);event.stopPropagation();}function initItems($menu){const options={class:'toolbar-icon toolbar-handle',action:ui.handleOpen,text:''};$menu.find('li > a').wrap('<div class="toolbar-box">');$menu.find('li').each((index,element)=>{const $item=$(element);if($item.children('ul.toolbar-menu').length){const $box=$item.children('.toolbar-box');const $link=$box.find('a');options.text=Drupal.t('@label',{'@label':$link.length?$link[0].textContent:''});$item.children('.toolbar-box').append($(Drupal.theme('toolbarMenuItemToggle',options)).hide().fadeIn(150));}});}function markListLevels($lists,level){level=!level?1:level;const $lis=$lists.children('li').addClass(`level-${level}`);$lists=$lis.children('ul');if($lists.length)markListLevels($lists,level+1);}function openActiveItem($menu){let currentPath=drupalSettings.path.currentPath;const pathItem=$menu.find(`a[href="${window.location.pathname}"]`);if(pathItem.length&&!activeItem)activeItem=window.location.pathname;if(activeItem){const $activeItem=$menu.find(`a[href="${activeItem}"]`).addClass('menu-item--active');if(pathItem.length===0&&activeItem){const count=currentPath.split('/').length;for(let i=0;i<count;i++){const $menuItem=$menu.find(`a[data-drupal-link-system-path="${currentPath}"]`);if($menuItem.length!==0){const $activeTrail=$menuItem.parentsUntil('.root','li').addClass('menu-item--active-trail');toggleList($activeTrail,true);break;}const lastIndex=currentPath.lastIndexOf('/');currentPath=currentPath.slice(0,lastIndex);}}else{const $activeTrail=$activeItem.parentsUntil('.root','li').addClass('menu-item--active-trail');toggleList($activeTrail,true);}}}return this.each(function(selector){const menu=once('toolbar-menu-vertical',this);if(menu.length){const $menu=$(menu);$menu.on('click.toolbar','.toolbar-box',toggleClickHandler).on('click.toolbar','.toolbar-box a',linkClickHandler);$menu.addClass('root');initItems($menu);markListLevels($menu);openActiveItem($menu);}});};Drupal.theme.toolbarMenuItemToggle=function(options){return `<button class="${options.class}"><span class="action">${options.action}</span> <span class="label">${options.text}</span></button>`;};})(jQuery,Drupal,drupalSettings);;
(function($,Drupal,drupalSettings){(()=>{if(!sessionStorage.getItem('Drupal.toolbar.toolbarState'))return;const toolbarState=JSON.parse(sessionStorage.getItem('Drupal.toolbar.toolbarState'));const {activeTray,orientation,isOriented}=toolbarState;const activeTrayElement=document.querySelector(`.toolbar-tray[data-toolbar-tray="${activeTray}"]`);const activeTrayToggle=document.querySelector(`.toolbar-item[data-toolbar-tray="${activeTray}"]`);if(activeTrayElement){activeTrayElement.classList.add(`toolbar-tray-${orientation}`,'is-active');activeTrayToggle.classList.add('is-active');}if(isOriented)document.querySelector('#toolbar-administration').classList.add('toolbar-oriented');})();const options=$.extend({breakpoints:{'toolbar.narrow':'','toolbar.standard':'','toolbar.wide':''}},drupalSettings.toolbar,{strings:{horizontal:Drupal.t('Horizontal orientation'),vertical:Drupal.t('Vertical orientation')}});Drupal.behaviors.toolbar={attach(context){if(!window.matchMedia('only screen').matches)return;once('toolbar','#toolbar-administration',context).forEach((toolbar)=>{const model=new Drupal.toolbar.ToolbarModel({locked:JSON.parse(localStorage.getItem('Drupal.toolbar.trayVerticalLocked')),activeTab:document.getElementById(JSON.parse(localStorage.getItem('Drupal.toolbar.activeTabID'))),height:$('#toolbar-administration').outerHeight()});Drupal.toolbar.models.toolbarModel=model;Object.keys(options.breakpoints).forEach((label)=>{const mq=options.breakpoints[label];const mql=window.matchMedia(mq);Drupal.toolbar.mql[label]=mql;mql.addListener(Drupal.toolbar.mediaQueryChangeHandler.bind(null,model,label));Drupal.toolbar.mediaQueryChangeHandler.call(null,model,label,mql);});Drupal.toolbar.views.toolbarVisualView=new Drupal.toolbar.ToolbarVisualView({el:toolbar,model,strings:options.strings});Drupal.toolbar.views.toolbarAuralView=new Drupal.toolbar.ToolbarAuralView({el:toolbar,model,strings:options.strings});Drupal.toolbar.views.bodyVisualView=new Drupal.toolbar.BodyVisualView({el:toolbar,model});model.trigger('change:isFixed',model,model.get('isFixed'));model.trigger('change:activeTray',model,model.get('activeTray'));const menuModel=new Drupal.toolbar.MenuModel();Drupal.toolbar.models.menuModel=menuModel;Drupal.toolbar.views.menuVisualView=new Drupal.toolbar.MenuVisualView({el:$(toolbar).find('.toolbar-menu-administration').get(0),model:menuModel,strings:options.strings});Drupal.toolbar.setSubtrees.done((subtrees)=>{menuModel.set('subtrees',subtrees);const theme=drupalSettings.ajaxPageState.theme;localStorage.setItem(`Drupal.toolbar.subtrees.${theme}`,JSON.stringify(subtrees));model.set('areSubtreesLoaded',true);});Drupal.toolbar.views.toolbarVisualView.loadSubtrees();$(document).on('drupalViewportOffsetChange.toolbar',(event,offsets)=>{model.set('offsets',offsets);});model.on('change:orientation',(model,orientation)=>{$(document).trigger('drupalToolbarOrientationChange',orientation);}).on('change:activeTab',(model,tab)=>{$(document).trigger('drupalToolbarTabChange',tab);}).on('change:activeTray',(model,tray)=>{$(document).trigger('drupalToolbarTrayChange',tray);});const toolbarState=sessionStorage.getItem('Drupal.toolbar.toolbarState')?JSON.parse(sessionStorage.getItem('Drupal.toolbar.toolbarState')):{};if(Drupal.toolbar.models.toolbarModel.get('orientation')==='horizontal'&&Drupal.toolbar.models.toolbarModel.get('activeTab')===null&&!toolbarState.orientation)Drupal.toolbar.models.toolbarModel.set({activeTab:$('.toolbar-bar .toolbar-tab:not(.home-toolbar-tab) a').get(0)});window.addEventListener('dialog:aftercreate',(e)=>{const $element=$(e.target);const {settings}=e;const toolbarBar=document.getElementById('toolbar-bar');if(toolbarBar){toolbarBar.style.marginTop='0';if(settings.drupalOffCanvasPosition==='top'){const height=Drupal.offCanvas.getContainer($element).outerHeight();toolbarBar.style.marginTop=`${height}px`;$element.on('dialogContentResize.off-canvas',()=>{const newHeight=Drupal.offCanvas.getContainer($element).outerHeight();toolbarBar.style.marginTop=`${newHeight}px`;});}}});window.addEventListener('dialog:beforeclose',()=>{const toolbarBar=document.getElementById('toolbar-bar');if(toolbarBar)toolbarBar.style.marginTop='0';});});if(once('toolbarAntiFlicker','#toolbar-administration',context).length)Drupal.toolbar.models.toolbarModel.on('change:activeTab change:orientation change:isOriented change:isTrayToggleVisible change:offsets',function(){const userButton=document.querySelector('#toolbar-item-user');const hasActiveTab=!!$(this.get('activeTab')).length>0;const previousToolbarState=sessionStorage.getItem('Drupal.toolbar.toolbarState')?JSON.parse(sessionStorage.getItem('Drupal.toolbar.toolbarState')):{};const toolbarState={...previousToolbarState,orientation:Drupal.toolbar.models.toolbarModel.get('orientation'),hasActiveTab,activeTabId:hasActiveTab?this.get('activeTab').id:null,activeTray:$(this.get('activeTab')).attr('data-toolbar-tray'),isOriented:this.get('isOriented'),isFixed:this.get('isFixed'),userButtonMinWidth:userButton?userButton.clientWidth:0};sessionStorage.setItem('Drupal.toolbar.toolbarState',JSON.stringify(toolbarState));});}};Drupal.toolbar={views:{},models:{},mql:{},setSubtrees:new $.Deferred(),mediaQueryChangeHandler(model,label,mql){switch(label){case 'toolbar.narrow':model.set({isOriented:mql.matches,isTrayToggleVisible:false});if(!mql.matches||!model.get('orientation'))model.set({orientation:'vertical'},{validate:true});break;case 'toolbar.standard':model.set({isFixed:mql.matches});break;case 'toolbar.wide':model.set({orientation:mql.matches&&!model.get('locked')?'horizontal':'vertical'},{validate:true});model.set({isTrayToggleVisible:mql.matches});break;default:break;}}};Drupal.theme.toolbarOrientationToggle=function(){return ('<div class="toolbar-toggle-orientation"><div class="toolbar-lining">'+'<button class="toolbar-icon" type="button"></button>'+'</div></div>');};Drupal.AjaxCommands.prototype.setToolbarSubtrees=function(ajax,response,status){Drupal.toolbar.setSubtrees.resolve(response.subtrees);};})(jQuery,Drupal,drupalSettings);;
(function(Backbone,Drupal){Drupal.toolbar.MenuModel=Backbone.Model.extend({defaults:{subtrees:null}});})(Backbone,Drupal);;
(function(Backbone,Drupal){Drupal.toolbar.ToolbarModel=Backbone.Model.extend({defaults:{activeTab:null,activeTray:null,isOriented:false,isFixed:false,areSubtreesLoaded:false,isViewportOverflowConstrained:false,orientation:'horizontal',locked:false,isTrayToggleVisible:true,height:null,offsets:{top:0,right:0,bottom:0,left:0}},validate(attributes,options){if(attributes.orientation==='horizontal'&&this.get('locked')&&!options.override)return Drupal.t('The toolbar cannot be set to a horizontal orientation when it is locked.');}});})(Backbone,Drupal);;
(function($,Drupal,Backbone){Drupal.toolbar.BodyVisualView=Backbone.View.extend({initialize(){this.listenTo(this.model,'change:activeTray ',this.render);this.listenTo(this.model,'change:isFixed change:isViewportOverflowConstrained',this.isToolbarFixed);},isToolbarFixed(){const isViewportOverflowConstrained=this.model.get('isViewportOverflowConstrained');$('body').toggleClass('toolbar-fixed',isViewportOverflowConstrained||this.model.get('isFixed'));},render(){$('body').toggleClass('toolbar-tray-open',!!this.model.get('activeTray'));}});})(jQuery,Drupal,Backbone);;
(function($,Backbone,Drupal){Drupal.toolbar.MenuVisualView=Backbone.View.extend({initialize(){this.listenTo(this.model,'change:subtrees',this.render);this.render();},render(){this.renderVertical();this.renderHorizontal();},renderHorizontal(){if('drupalToolbarMenu' in $.fn)this.$el.children('.toolbar-menu').drupalToolbarMenuHorizontal();},renderVertical(){const subtrees=this.model.get('subtrees');if(!this.model.get('subtrees'))return;Object.keys(subtrees||{}).forEach((id)=>{$(once('toolbar-subtrees',this.$el.find(`#toolbar-link-${id}`))).after(subtrees[id]);});if('drupalToolbarMenu' in $.fn)this.$el.children('.toolbar-menu').drupalToolbarMenu();}});})(jQuery,Backbone,Drupal);;
(function(Backbone,Drupal){Drupal.toolbar.ToolbarAuralView=Backbone.View.extend({initialize(options){this.strings=options.strings;this.listenTo(this.model,'change:orientation',this.onOrientationChange);this.listenTo(this.model,'change:activeTray',this.onActiveTrayChange);},onOrientationChange(model,orientation){Drupal.announce(Drupal.t('Tray orientation changed to @orientation.',{'@orientation':orientation}));},onActiveTrayChange(model,tray){const relevantTray=tray===null?model.previous('activeTray'):tray;if(!relevantTray)return;const action=tray===null?Drupal.t('closed'):Drupal.t('opened');const trayNameElement=relevantTray.querySelector('.toolbar-tray-name');let text;if(trayNameElement!==null)text=Drupal.t('Tray "@tray" @action.',{'@tray':trayNameElement.textContent,'@action':action});else text=Drupal.t('Tray @action.',{'@action':action});Drupal.announce(text);}});})(Backbone,Drupal);;
(function($,Drupal,drupalSettings,Backbone){Drupal.toolbar.ToolbarVisualView=Backbone.View.extend({events(){const touchEndToClick=function(event){event.preventDefault();event.target.click();};return {'click .toolbar-bar .toolbar-tab .trigger':'onTabClick','click .toolbar-toggle-orientation button':'onOrientationToggleClick','touchend .toolbar-bar .toolbar-tab .trigger':touchEndToClick,'touchend .toolbar-toggle-orientation button':touchEndToClick};},initialize(options){this.strings=options.strings;this.listenTo(this.model,'change:activeTab change:orientation change:isOriented change:isTrayToggleVisible',this.render);this.listenTo(this.model,'change:mqMatches',this.onMediaQueryChange);this.listenTo(this.model,'change:offsets',this.adjustPlacement);this.listenTo(this.model,'change:activeTab change:orientation change:isOriented',this.updateToolbarHeight);this.$el.find('.toolbar-tray .toolbar-lining').has('.toolbar-menu').append(Drupal.theme('toolbarOrientationToggle'));this.model.trigger('change:activeTab');},updateToolbarHeight(){const toolbarTabOuterHeight=$('#toolbar-bar').find('.toolbar-tab').outerHeight()||0;const toolbarTrayHorizontalOuterHeight=$('.is-active.toolbar-tray-horizontal').outerHeight()||0;this.model.set('height',toolbarTabOuterHeight+toolbarTrayHorizontalOuterHeight);$('body')[0].style.paddingTop=`${this.model.get('height')}px`;$('html')[0].style.scrollPaddingTop=`${this.model.get('height')}px`;this.triggerDisplace();},triggerDisplace(){_.defer(()=>{Drupal.displace(true);});},render(){this.updateTabs();this.updateTrayOrientation();this.updateBarAttributes();$('[data-toolbar-anti-flicker-loading]').remove();$('html').removeClass(['toolbar-loading','toolbar-horizontal','toolbar-vertical','toolbar-tray-open','toolbar-fixed','toolbar-oriented','toolbar-anti-flicker']);$('body').removeClass('toolbar-loading');if(this.model.changed.orientation==='vertical'||this.model.changed.activeTab)this.loadSubtrees();return this;},onTabClick(event){if(event.currentTarget.hasAttribute('data-toolbar-tray')){const activeTab=this.model.get('activeTab');const clickedTab=event.currentTarget;this.model.set('activeTab',!activeTab||clickedTab!==activeTab?clickedTab:null);event.preventDefault();event.stopPropagation();}},onOrientationToggleClick(event){const orientation=this.model.get('orientation');const antiOrientation=orientation==='vertical'?'horizontal':'vertical';const locked=antiOrientation==='vertical';if(locked)localStorage.setItem('Drupal.toolbar.trayVerticalLocked','true');else localStorage.removeItem('Drupal.toolbar.trayVerticalLocked');this.model.set({locked,orientation:antiOrientation},{validate:true,override:true});event.preventDefault();event.stopPropagation();},updateTabs(){const $tab=$(this.model.get('activeTab'));$(this.model.previous('activeTab')).removeClass('is-active').prop('aria-pressed',false);$(this.model.previous('activeTray')).removeClass('is-active');localStorage.removeItem('Drupal.toolbar.activeTabID');if($tab.length>0){$tab.addClass('is-active').prop('aria-pressed',true);const name=$tab.attr('data-toolbar-tray');const id=$tab.get(0).id;if(id)localStorage.setItem('Drupal.toolbar.activeTabID',JSON.stringify(id));const $tray=this.$el.find(`[data-toolbar-tray="${name}"].toolbar-tray`);if($tray.length){$tray.addClass('is-active');this.model.set('activeTray',$tray.get(0));}else this.model.set('activeTray',null);}else{this.model.set('activeTray',null);localStorage.removeItem('Drupal.toolbar.activeTabID');}},updateBarAttributes(){const isOriented=this.model.get('isOriented');if(isOriented)this.$el.find('.toolbar-bar').attr('data-offset-top','');else this.$el.find('.toolbar-bar').removeAttr('data-offset-top');this.$el.toggleClass('toolbar-oriented',isOriented);},updateTrayOrientation(){const orientation=this.model.get('orientation');const antiOrientation=orientation==='vertical'?'horizontal':'vertical';$('body').toggleClass('toolbar-vertical',orientation==='vertical').toggleClass('toolbar-horizontal',orientation==='horizontal');const removeClass=antiOrientation==='horizontal'?'toolbar-tray-horizontal':'toolbar-tray-vertical';const $trays=this.$el.find('.toolbar-tray').removeClass(removeClass).addClass(`toolbar-tray-${orientation}`);const iconClass=`toolbar-icon-toggle-${orientation}`;const iconAntiClass=`toolbar-icon-toggle-${antiOrientation}`;const $orientationToggle=this.$el.find('.toolbar-toggle-orientation').toggle(this.model.get('isTrayToggleVisible'));const $orientationToggleButton=$orientationToggle.find('button');$orientationToggleButton[0].value=antiOrientation;$orientationToggleButton.attr('title',this.strings[antiOrientation]).removeClass(iconClass).addClass(iconAntiClass);$orientationToggleButton[0].textContent=this.strings[antiOrientation];const dir=document.documentElement.dir;const edge=dir==='rtl'?'right':'left';$trays.removeAttr('data-offset-left data-offset-right data-offset-top');$trays.filter('.toolbar-tray-vertical.is-active').attr(`data-offset-${edge}`,'');$trays.filter('.toolbar-tray-horizontal.is-active').attr('data-offset-top','');},adjustPlacement(){const $trays=this.$el.find('.toolbar-tray');if(!this.model.get('isOriented'))$trays.removeClass('toolbar-tray-horizontal').addClass('toolbar-tray-vertical');},loadSubtrees(){const $activeTab=$(this.model.get('activeTab'));const orientation=this.model.get('orientation');if(!this.model.get('areSubtreesLoaded')&&typeof $activeTab.data('drupal-subtrees')!=='undefined'&&orientation==='vertical'){const subtreesHash=drupalSettings.toolbar.subtreesHash;const theme=drupalSettings.ajaxPageState.theme;const endpoint=Drupal.url(`toolbar/subtrees/${subtreesHash}`);const cachedSubtreesHash=localStorage.getItem(`Drupal.toolbar.subtreesHash.${theme}`);const cachedSubtrees=JSON.parse(localStorage.getItem(`Drupal.toolbar.subtrees.${theme}`));const isVertical=this.model.get('orientation')==='vertical';if(isVertical&&subtreesHash===cachedSubtreesHash&&cachedSubtrees)Drupal.toolbar.setSubtrees.resolve(cachedSubtrees);else{if(isVertical){localStorage.removeItem(`Drupal.toolbar.subtreesHash.${theme}`);localStorage.removeItem(`Drupal.toolbar.subtrees.${theme}`);Drupal.ajax({url:endpoint}).execute();localStorage.setItem(`Drupal.toolbar.subtreesHash.${theme}`,subtreesHash);}}}}});})(jQuery,Drupal,drupalSettings,Backbone);;
(function($,Drupal,drupalSettings){const pathInfo=drupalSettings.path;const escapeAdminPath=sessionStorage.getItem('escapeAdminPath');const windowLocation=window.location;if(!pathInfo.currentPathIsAdmin&&!/destination=/.test(windowLocation.search))sessionStorage.setItem('escapeAdminPath',windowLocation);Drupal.behaviors.escapeAdmin={attach(){const toolbarEscape=once('escapeAdmin','[data-toolbar-escape-admin]');if(toolbarEscape.length&&pathInfo.currentPathIsAdmin&&escapeAdminPath!==null)$(toolbarEscape).attr('href',escapeAdminPath);}};})(jQuery,Drupal,drupalSettings);;
